#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Artober - AcidMod01.fsh   by Flopine   
//https://www.shadertoy.com/view/msf3z7
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Code by Flopine

// Thanks to wsmind, leon, XT95, lsdlive, lamogui, 
// Coyhot, Alkama,YX, NuSan, slerpy, wwrighter 
// BigWings, FabriceNeyret and Blackle for teaching me

// Thanks LJ for giving me the spark :3

// Thanks to the Cookie Collective, which build a cozy and safe environment for me 
// and other to sprout :)  
// https://twitter.com/CookieDemoparty


#define PI acos(-1.)
#define TAU (2.*PI)
#define hr vec2(1.,sqrt(3.))

#define rot(a) mat2(cos(a),sin(a),-sin(a),cos(a))

#define hd(u, s) (max(abs(u.x), dot(abs(u), normalize(hr)))-s)
#define circle(u,s) (length(u)-s)
#define AAstep(thre, val) smoothstep(-.7,.7,(val-thre)/min(0.02,fwidth(val-thre)))

#define palette(t,c,d) (vec3(0.5)+vec3(0.5)*cos(TAU*(c*t+d)) )

#define noise(u) textureLod(texture0, u, 0.).x


float moda(inout vec2 p, float rep)
{
    float per = TAU/rep;
    float a = atan(p.y,p.x);
    float c = floor(a/per);
    a = mod(a,per)-per*.5;
    if (abs(c) >= (rep*.5)) c = abs(c);
    p = vec2(cos(a), sin(a))*length(p);
    return c;
}

vec4 hexgrid (vec2 uv)
{
    vec2 ga=mod(uv,hr)-hr*.5, gb=mod(uv-hr*.5,hr)-hr*.5, 
    guv=dot(ga,ga)<dot(gb,gb)?ga:gb, gid=uv-guv;
    return vec4(guv,gid);
}

vec3 frame (vec2 uv)
{
    vec4 hg = hexgrid(uv);
    vec2 uu = hg.xy, uid = hg.zw;    
    float uswi = noise(uid*.25);
    
    float h = 1.;
    
    float aid = moda(uu, 6.);  
    h *= AAstep(0.001, abs(uu.y)-0.01);
    
    if (uswi <.5)
    {
        uu.x -= 0.5;
        h *= AAstep( 0.02, abs(circle(uu, 0.25)) );
    }

    h *= AAstep( 0.02, abs(circle(uu, 0.35)) ); 
    uu.x -= 0.435;
    h *= AAstep(0.001, abs(uu.x)-0.01);
    
    return mix(palette(aid+mod(uid.x*uid.y, 2.), vec3(.1), vec3(0.3,0.8,0.1)), vec3(0.),  h);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (2.*fragCoord-iResolution.xy)/iResolution.y;
    
    uv.y += iTime*.3;
    uv *= 2.;
    
    vec3 col = frame(uv);

    fragColor = vec4(sqrt(col),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

